#ifndef _INFORMATION_H
#define _INFORMATION_H

#include <QString>

class Information
{
	public:
		Information();
		Information(QString title, QString hostAddress, QString userName, QString password, QString port, QString database);
		virtual ~Information();

	public:
		Information(const Information& source);
		Information& operator=(const Information& source);

	public:
		QString& GetTitle() const;
		QString& GetHostAddress() const;
		QString& GetUserName() const;
		QString& GetPassword() const;
		QString& GetPort() const;
		QString& GetDatabase() const;

	private:
		QString title;
		QString hostAddress;
		QString userName;
		QString password;
		QString port;
		QString database;
};

inline QString& Information::GetTitle() const
{
	return const_cast<QString&>(this->title);
}

inline QString& Information::GetHostAddress() const
{
	return const_cast<QString&>(this->hostAddress);
}

inline QString& Information::GetUserName() const
{
	return const_cast<QString&>(this->userName);
}

inline QString& Information::GetPassword() const
{
	return const_cast<QString&>(this->password);
}

inline QString& Information::GetPort() const
{
	return const_cast<QString&>(this->port);
}

inline QString& Information::GetDatabase() const
{
	return const_cast<QString&>(this->database);
}


#endif //_INFORMATION_H
